import LicenseSpring

import SwiftUI

struct LicenseView: View {
    let manager: LicenseManaging?
    let license: License?
    let isVM: Bool
    @EnvironmentObject private var viewUpdater: ViewUpdaterHack
    
    var body: some View {
        HStack {
            VStack {
                LicenseGeneralInfoView(manager: manager, license: license)
                if isVM {
                    Text("Virtual machine detected")
                        .foregroundColor(.red)
                        .fontWeight(.bold)
                        .frame(alignment: .leading)
                }
                Spacer()
            }
            VStack {
                LicenseAdditionalInfoView(license: license)
                Spacer()
            }
        }
        .padding()
    }
}

struct LicenseView_Previews: PreviewProvider {
    static var previews: some View {
        LicenseView(manager: nil, license: nil, isVM: true)
    }
}
